/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.DDF0XAWriter;
import app.DDF255Writer;
import app.FitDataSet;
import app.InlineWriter;
import app.InputLine;
import app.PlotDataXY;
import app.RawDataSet;
import app.SingleShot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import util.Config;
import util.Logger;
import util.SystemCall;
import view.MainView;
import view.PlotWindow;

public class Application {
    static Logger logger = Logger.getLogger();
    private RawDataSet myRawDataSet;
    private FitDataSet myFitDataSet;
    private MainView myView;
    private String myDataDir;
    private String rawdataextension = ".azi";

    public FitDataSet getFitDataSet() {
        return this.myFitDataSet;
    }

    public void setDataDir(String s) {
        this.myDataDir = s;
    }

    public String getDataDir() {
        return this.myDataDir;
    }

    public Application() {
        logger.entry(4, "Application.Application");
        this.myView = new MainView(this);
        this.myView.setVisible(true);
        this.myDataDir = "";
        this.myRawDataSet = new RawDataSet();
        this.myFitDataSet = new FitDataSet(this.myView, this.myRawDataSet);
        Config cfg = Config.getConfig();
        if (cfg.getParam("Rawdatatype").equals("azi")) {
            this.myView.DegreesRadio.setSelected(true);
            this.myRawDataSet.setDatatypeAzimuth(true);
        } else {
            this.myView.ComplexRadio.setSelected(true);
            this.myRawDataSet.setDatatypeAzimuth(false);
        }
        if (!cfg.getParam("Unused01").equals("4711")) {
            this.myView.DegreesRadio.setSelected(true);
            this.myRawDataSet.setDatatypeAzimuth(true);
            this.myFitDataSet.setCorrAlgo("Ambi");
        }
        logger.exit(4, "Application.Application");
    }

    public void readData() {
        logger.entry(4, "Application.readData");
        this.myRawDataSet.clear();
        boolean retcode = true;
        File file = null;
        if (this.myDataDir == "") {
            this.myView.displayWarning("Working directory is not defined!");
            retcode = false;
        }
        if (retcode && !(file = new File(this.myDataDir)).isDirectory()) {
            this.myView.displayWarning("Working must be a directory!");
            retcode = false;
        }
        if (retcode) {
            file = new File(this.myDataDir);
            String[] entries = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    return name.toLowerCase().endsWith(Application.this.rawdataextension);
                }
            });
            int i = 0;
            while (i < entries.length) {
                this.readFile(String.valueOf(this.myDataDir) + "\\" + entries[i]);
                ++i;
            }
            this.myView.displayStatus("opened " + entries.length + " files");
            this.updateControls();
            this.myView.displayRms(0.0);
            this.calcRMSIn();
            this.myFitDataSet = new FitDataSet(this.myView, this.myRawDataSet);
        }
        logger.exit(4, "Application.readData");
    }

    private void readFile(String name) {
        block13: {
            logger.entry(4, "Application.readFile " + name);
            BufferedReader brd = null;
            String comment = Config.getConfig().getParam("Comment");
            try {
                try {
                    brd = new BufferedReader(new FileReader(name));
                    String line = brd.readLine();
                    while (line != null) {
                        InputLine l = new InputLine(line);
                        if (!line.startsWith(comment)) {
                            SingleShot shot = new SingleShot(l.getCategory(), l.getAzi(), l.getRealX(), l.getRealY(), l.getImagX(), l.getImagY());
                            this.myRawDataSet.addShot(l.getTarget(), l.getFreq(), shot);
                        }
                        line = brd.readLine();
                    }
                }
                catch (IOException e) {
                    System.out.println("Error reading file!");
                    try {
                        brd.close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    brd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                brd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.exit(4, "Application.readFile");
    }

    private void updateControls() {
        logger.entry(4, "Application.updateControls");
        this.myView.setFreqCombos(this.myRawDataSet.getFreqList());
        this.myView.setTargetCombos(this.myRawDataSet.getTargetList());
        logger.exit(4, "Application.updateControls");
    }

    public void DegreesRadioChanged() {
        logger.entry(4, "Application.DegreesRadioChanged");
        Config cfg = Config.getConfig();
        if (this.myView.DegreesRadio.isSelected()) {
            this.myRawDataSet.setDatatypeAzimuth(true);
            cfg.setParam("Rawdatatype", "azi");
        } else {
            this.myRawDataSet.setDatatypeAzimuth(false);
            cfg.setParam("Rawdatatype", "cpl");
        }
        logger.exit(4, "Application.DegreesRadioChanged");
    }

    public void calcRMSIn() {
        logger.entry(1, "Application.calcRMSIn");
        double rms = 0.0;
        if (this.myRawDataSet.getReady()) {
            rms = this.myRawDataSet.getGlobalRMS();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        this.myView.displayRms(rms);
        logger.exit(1, "Application.calcRMSIn");
    }

    public void calcRMSOut() {
        logger.entry(1, "Application.calcRMSOut");
        double rms = 0.0;
        if (this.myRawDataSet.getReady()) {
            String tg = this.myView.getFitTarget();
            logger.log(5, "target = " + tg);
            rms = tg.equals("all") ? this.myFitDataSet.getGlobalRMS() : this.myFitDataSet.getRmsForTarget(Double.parseDouble(tg));
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        this.myView.displayFitRms(rms);
        logger.exit(1, "Application.calcRMSOut");
    }

    public void plotAziForFreq() {
        logger.entry(4, "Application.plotAziForFreq");
        if (this.myRawDataSet.getReady()) {
            double f = this.myView.getRawFreq();
            logger.log(5, "Frequency = " + f);
            PlotDataXY pd = this.myRawDataSet.getAziDataForFreq(f);
            double rms = this.myRawDataSet.getRMSForFreq(f);
            rms = Math.rint(rms * 100.0) / 100.0;
            double rf = f / 1000000.0;
            PlotWindow pw = this.myView.getNewPlotWindow();
            pw.setCaption("Azimuth at " + rf + " MHz, rms = " + rms);
            pw.setXLabel("Nominal Azimuth / deg");
            pw.setYLabel("Actual Bearing / deg");
            pw.setVisible(true);
            pw.addPlotDataXY(pd);
            pw.displayPlot();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.plotAziForFreq");
    }

    public void nextAziForFreq() {
        logger.entry(4, "Application.nextAziForFreq");
        if (this.myRawDataSet.getReady()) {
            this.myView.nextRawFreq();
            this.plotAziForFreq();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.nextAziForFreq");
    }

    public void plotAziForTarget() {
        logger.entry(1, "Application.plotAziForTarget");
        if (this.myRawDataSet.getReady()) {
            double t = this.myView.getRawTarget();
            logger.log(5, "Target = " + t);
            PlotDataXY pd = this.myRawDataSet.getAziDataForTarget(t);
            double rms = this.myRawDataSet.getRMSForTarget(t);
            rms = Math.rint(rms * 100.0) / 100.0;
            pd.scaleX(1.0E-6);
            pd.correct360DegVersusTarget(t);
            PlotWindow pw = this.myView.getNewPlotWindow();
            pw.setCaption("Nominal Azimuth " + t + " deg, rms = " + rms);
            pw.setXLabel("Frequency / MHz");
            pw.setYLabel("Actual Bearing / deg");
            pw.setVisible(true);
            pw.addPlotDataXY(pd);
            pw.displayPlot();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(1, "Application.plotAziForTarget");
    }

    public void nextAziForTarget() {
        logger.entry(4, "Application.nextAziForTarget");
        if (this.myRawDataSet.getReady()) {
            this.myView.nextRawTarget();
            this.plotAziForTarget();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.nextAziForTarget");
    }

    public void plotFit() {
        logger.entry(4, "Application.plotFit");
        if (this.myRawDataSet.getReady()) {
            double f = this.myView.getFitFreq();
            logger.log(5, "Frequency = " + f);
            this.myFitDataSet.fitCorrection(f);
            PlotDataXY pd1 = this.myFitDataSet.getFitData(f).getDataIn();
            PlotDataXY pd2 = this.myFitDataSet.getFitData(f).getDataOut();
            double rms = this.myFitDataSet.getFitData(f).getRmsOut();
            rms = Math.rint(rms * 100.0) / 100.0;
            double rf = f / 1000000.0;
            PlotWindow pw = this.myView.getNewPlotWindow();
            pw.setVisible(true);
            pw.addPlotDataXY(pd1);
            pw.addPlotDataXY(pd2);
            pw.setCaption("Fit Graph at " + rf + " MHz, rms = " + rms);
            pw.setXLabel("Nominal Azimuth / deg");
            pw.setYLabel("Actual Bearing / deg");
            pw.displayPlot();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.plotFit");
    }

    public void nextFit() {
        logger.entry(4, "Application.nextFitSlopeForTarget");
        if (this.myRawDataSet.getReady()) {
            this.myView.nextFitFreq();
            this.plotFit();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.nextFitSlopeForTarget");
    }

    public void plotCorrVal() {
        logger.entry(4, "Application.plotCorrVal");
        if (this.myRawDataSet.getReady()) {
            double freq = this.myView.getCorrFreq();
            logger.log(5, "frequency = " + freq);
            PlotDataXY pd = this.myFitDataSet.getFitData(freq).getCorrVals();
            double rf = freq / 1000000.0;
            PlotWindow pw = this.myView.getNewPlotWindow();
            pw.setVisible(true);
            pw.addPlotDataXY(pd);
            pw.setCaption("Correction Data at " + rf + " MHz");
            pw.setXLabel("Actual Bearing / deg");
            pw.setYLabel("Correction Data / deg");
            pw.displayPlot();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.plotCorrVal");
    }

    public void nextCorrVal() {
        logger.entry(4, "Application.nextCorrVal");
        if (this.myRawDataSet.getReady()) {
            this.myView.nextCorrFreq();
            this.plotCorrVal();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.nextCorrVal");
    }

    public void plotCorrSimul() {
        logger.entry(4, "Application.plotCorrSimul");
        if (this.myRawDataSet.getReady()) {
            double freq = this.myView.getSimulFreq();
            logger.log(5, "frequency = " + freq);
            PlotDataXY pd = this.myFitDataSet.getFitData(freq).getSimulVals();
            double rms = this.myFitDataSet.getFitData(freq).getRmsSimul();
            rms = Math.rint(rms * 100.0) / 100.0;
            double rf = freq / 1000000.0;
            PlotWindow pw = this.myView.getNewPlotWindow();
            pw.setVisible(true);
            pw.addPlotDataXY(pd);
            pw.setCaption("Simulated Correction at " + rf + " MHz, rms = " + rms);
            pw.setXLabel("Actual Bearing / deg");
            pw.setYLabel("Corrected Bearing / deg");
            pw.displayPlot();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.plotCorrSimul");
    }

    public void nextCorrSimul() {
        logger.entry(4, "Application.nextCorrSimul");
        if (this.myRawDataSet.getReady()) {
            this.myView.nextSimulFreq();
            this.plotCorrSimul();
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.nextCorrSimul");
    }

    public void resetFitData() {
        logger.entry(4, "Application.resetFitData");
        this.myFitDataSet = null;
        this.myFitDataSet = new FitDataSet(this.myView, this.myRawDataSet);
        logger.exit(4, "Application.resetFitData");
    }

    public void writeData(File outfile) {
        logger.entry(4, "Application.writeData");
        if (this.myRawDataSet.getReady()) {
            if (outfile != null) {
                Object Writer2;
                logger.log(5, "Outfile Name = " + outfile.getName());
                Config cfg = Config.getConfig();
                if (cfg.getParam("Filetype").equals("DDF0XA")) {
                    Writer2 = new DDF0XAWriter(outfile, this.myFitDataSet);
                    ((DDF0XAWriter)Writer2).write();
                } else if (cfg.getParam("Filetype").equals("Inline")) {
                    Writer2 = new InlineWriter(outfile, this.myFitDataSet);
                    ((InlineWriter)Writer2).write();
                } else {
                    Writer2 = new DDF255Writer(outfile, this.myFitDataSet);
                    ((DDF255Writer)Writer2).write();
                }
                this.myView.displayStatus("output file written");
                if (cfg.getParam("DataFormat") == "binary") {
                    SystemCall cl = new SystemCall("asci2bin32 " + outfile.getName());
                    cl.execute();
                }
            } else {
                this.myView.displayWarning("No valid output file!");
            }
        } else {
            this.myView.displayWarning("No input data defined!");
        }
        logger.exit(4, "Application.writeData");
    }

    public void writeData() {
        logger.entry(4, "Application.writeData");
        Config cfg = Config.getConfig();
        File outfile = new File(String.valueOf(cfg.getParam("Filename")) + ".asc");
        this.writeData(outfile);
        logger.exit(4, "Application.writeData");
    }

    public void displayWarning(String s) {
        this.myView.displayWarning(s);
    }

    public static void main(String[] args) {
        logger.log(1, "start Application.main");
        Application a = new Application();
        logger.log(1, "stop Application.main");
    }
}

